import React from 'react';



interface InfoCardProps {
  title: string;
  description?: string;
  imageUrl?: string;
  showAdsense?: boolean;
}


import Adsense from "@/components/Adsense";

const InfoCard: React.FC<InfoCardProps> = ({ title, description, imageUrl, showAdsense }) => {
  return (
    <div className="border rounded-lg p-4 bg-white shadow-sm flex flex-col justify-between h-full items-center">
      {imageUrl && (
        <img
          src={imageUrl}
          alt={title}
          className="max-w-[80%] max-h-24 object-contain mb-2 rounded"
        />
      )}
      <h3 className="font-semibold text-lg text-center">{title}</h3>
      {description && <p className="text-sm text-gray-500 mt-2 text-center">{description}</p>}
      {showAdsense && <Adsense 
            adClient="ca-pub-YOUR_ADSENSE_PUBLISHER_ID" 
            adSlot="YOUR_ADSENSE_AD_UNIT_ID" 
        />}
    </div>
  );
};

export default InfoCard;