"use client"

import { useState } from "react"
import { ChevronDown, Filter, RotateCcw } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Checkbox } from "@/components/ui/checkbox"
import { Input } from "@/components/ui/input"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
import { Collapsible, CollapsibleContent, CollapsibleTrigger } from "@/components/ui/collapsible"
import { Sheet, SheetContent, SheetHeader, SheetTitle, SheetTrigger } from "@/components/ui/sheet"

interface SidebarProps {
  filters: any
  onFiltersChange: (filters: any) => void
  products: any[]
}

export default function Sidebar({ filters, onFiltersChange, products }: SidebarProps) {
  const [isOpen, setIsOpen] = useState(false)
  const [sheetOpen, setSheetOpen] = useState(false)

  const resetFilters = () => {
    onFiltersChange({
      category: "*",
      subCategories: [],
      brands: [],
      contents: [],
      rating: { green: false, red: false },
      search: "",
    })
  }

  const uniqueBrands = [...new Set(products.map((p: any) => {
    if (typeof p.brand === 'string') return p.brand;
    if (p.brand && typeof p.brand === 'object' && 'name' in p.brand) return (p.brand as { name: string }).name;
    return undefined;
  }))].filter(Boolean).sort() as string[];
  const uniqueSubCategories = filters.category && filters.category !== '*' ?
    [...new Set(products.filter((p) => p.category === filters.category).map((p) => p.subCategory).filter(Boolean))].sort()
    : [];

  return (
    <aside className="w-60 h-[calc(100vh-56px)] sticky top-0 left-0 bg-white border-r border-gray-200 shadow-sm flex-shrink-0 hidden md:flex flex-col p-4">
      <div className="flex flex-col gap-6 h-full justify-start">
          {/* Selected Category */}
          <div>
          <p className="text-sm font-semibold mb-2 text-gray-700">Seçili Kategori:</p>
          <span className="text-blue-600 text-base font-bold">{filters.category === "*" ? "Tümü" : filters.category}</span>
          </div>

          {/* Sub Categories */}
          {filters.category && filters.category !== '*' && uniqueSubCategories.length > 0 && (
            <Collapsible>
              <CollapsibleTrigger className="flex items-center justify-between w-full px-2 py-2 hover:bg-gray-100 rounded text-sm font-medium">
                <span>Alt Kategori</span>
                <ChevronDown className="h-4 w-4" />
              </CollapsibleTrigger>
              <CollapsibleContent className="space-y-2 mt-2">
                <Input placeholder="Alt kategori ara..." className="text-sm h-8" />
                <div className="max-h-40 overflow-y-auto flex flex-col gap-2">
                  {uniqueSubCategories.map((subCat) => (
                    <label key={subCat} htmlFor={`subcat-${subCat}`} className="flex items-center gap-2 cursor-pointer text-sm">
                      <Checkbox id={`subcat-${subCat}`} checked={filters.subCategories.includes(subCat)} onCheckedChange={() => {
                        const newSubs = filters.subCategories.includes(subCat)
                          ? filters.subCategories.filter((s: string) => s !== subCat)
                          : [...filters.subCategories, subCat];
                        onFiltersChange({ ...filters, subCategories: newSubs });
                      }} />
                      {subCat}
                    </label>
                  ))}
                </div>
              </CollapsibleContent>
            </Collapsible>
          )}

          {/* Brands */}
          <Collapsible>
          <CollapsibleTrigger className="flex items-center justify-between w-full px-2 py-2 hover:bg-gray-100 rounded text-sm font-medium">
            <span>Marka</span>
              <ChevronDown className="h-4 w-4" />
            </CollapsibleTrigger>
            <CollapsibleContent className="space-y-2 mt-2">
            <Input placeholder="Marka ara..." className="text-sm h-8" />
            <div className="max-h-40 overflow-y-auto flex flex-col gap-2">
              {uniqueBrands.map((brand) => {
                const brandKey = typeof brand === 'string' ? brand : brand?.name;
                return (
                  <label key={brandKey} htmlFor={`brand-${brandKey}`} className="flex items-center gap-2 cursor-pointer text-sm">
                    <Checkbox id={`brand-${brandKey}`} checked={filters.brands.includes(brandKey)} onCheckedChange={() => {
                      const newBrands = filters.brands.includes(brandKey)
                        ? filters.brands.filter((b: string) => b !== brandKey)
                        : [...filters.brands, brandKey];
                      onFiltersChange({ ...filters, brands: newBrands });
                    }} />
                    {brandKey}
                    </label>
                );
              })}
              </div>
            </CollapsibleContent>
          </Collapsible>

          {/* Rating Filter */}
            <div className="space-y-2">
          <h3 className="font-medium text-sm mb-1">Puan Durumu</h3>
          <div className="flex flex-col gap-2">
            <label htmlFor="high-rating" className="flex items-center gap-2 cursor-pointer text-sm">
                <Checkbox id="high-rating" />
                  Yüksek Puanlı (4+)
                </label>
            <label htmlFor="low-rating" className="flex items-center gap-2 cursor-pointer text-sm">
                <Checkbox id="low-rating" />
                  Düşük Puanlı (3-)
                </label>
            </div>
          </div>

          {/* Sorting */}
        <div className="space-y-2">
          <h3 className="font-medium text-sm mb-1">Sıralama</h3>
            <Select defaultValue="default">
            <SelectTrigger className="h-8 text-sm">
                <SelectValue placeholder="Sıralama seçin" />
              </SelectTrigger>
              <SelectContent>
                <SelectItem value="default">Önerilen</SelectItem>
                <SelectItem value="rating-desc">Puana Göre (Yüksek)</SelectItem>
                <SelectItem value="rating-asc">Puana Göre (Düşük)</SelectItem>
                <SelectItem value="name-asc">Ada Göre (A-Z)</SelectItem>
                <SelectItem value="name-desc">Ada Göre (Z-A)</SelectItem>
              </SelectContent>
            </Select>
          </div>

          {/* Action Buttons */}
        <div className="flex gap-2 pt-4 border-t border-gray-200">
          <Button onClick={resetFilters} variant="outline" className="flex-1 h-9 text-sm">
            <RotateCcw className="h-4 w-4 mr-1" />
              Sıfırla
            </Button>
          <Button className="flex-1 h-9 text-sm">Uygula</Button>
          </div>
    </div>
    </aside>
  )
}
